#if (!require("BiocManager"))
#    install.packages("BiocManager")
#BiocManager::install("maftools")


library(maftools)       #library package
setwd("D:\\metabolism\\LGG\\9.mutation\\2.Maftools")     

#read risk file
risk=read.table("risk.txt", header=T, sep="\t", check.names=F)
outTab=risk[,c(1, ncol(risk))]
colnames(outTab)=c("Tumor_Sample_Barcode", "metabolismcluster")
write.table(outTab, file="ann.txt", sep="\t", quote=F, row.names=F)

#Read gene mutation files
geneNum=20    #Number of genes, showing the 20 genes with the highest mutation frequency and FGFR3
geneMut=read.table("geneMut.txt", header=T, sep="\t", check.names=F, row.names=1)
gene=row.names(geneMut)[1:geneNum]

#Define the color of the annotation
ann_colors=list()
col=c("#415DB9","#EC5D3B")
names(col)=c("C1", "C2")
ann_colors[["metabolismcluster"]]=col

vc_cols = RColorBrewer::brewer.pal(n = 8, name = 'Paired')
names(vc_cols) = c(
  'Frame_Shift_Del',
  'Missense_Mutation',
  'Nonsense_Mutation',
  'Multi_Hit',
  'Frame_Shift_Ins',
  'In_Frame_Ins',
  'Splice_Site',
  'In_Frame_Del'
)

#C1 Group Waterfall Chart
pdf(file="C1.pdf", width=6, height=6)
maf=read.maf(maf="low.maf", clinicalData="ann.txt")
oncoplot(maf=maf, colors = vc_cols, clinicalFeatures="metabolismcluster", genes=gene, annotationColor=ann_colors, keepGeneOrder=T)
dev.off()

#C2 Group Waterfall Chart
pdf(file="C2.pdf", width=6, height=6)
maf=read.maf(maf="high.maf", clinicalData="ann.txt")
oncoplot(maf=maf, colors = vc_cols, clinicalFeatures="metabolismcluster", genes=gene, annotationColor=ann_colors, keepGeneOrder=T)
dev.off()


